﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;

namespace CashierCrisis.Entities
{
    public abstract class Component
    {
        private string _name;
        public string Name
        {
            get { return _name; }
            set { _name = value; }
        }

        private Entity _entity;
        public Entity Entity
        {
            get { return _entity; }
            set 
            {
                _entity = value;
                OnAttached(_entity);
            }
        }

        public Component(string name)
        {
            _name = name;
        }

        public virtual void CopyTo(Component component)
        {
            component.Name = this.Name;
        }

        public virtual void Update(GameTime gameTime)
        {
            return;
        }

        public virtual void Draw(SpriteBatch spriteBatch)
        {
            return;
        }

        public virtual void OnAttached(Entity entity)
        {
        }
    }
}
